/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logoff;

import com.ibm.hwmca.base.logoff.LogoffErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionEvent;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionListener;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.servlet.util.TaskWindowPositionManager;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpSession;

public class LogoffApp
extends PresentationTask
implements LogoffErrorIds,
PmDataBean,
ModelActionListener {
    private static final String TASKLET_NAME = "com.ibm.hwmca.base.logoff.LogoffTasklet";
    private static final String TRACE_MASKT = "XLOGOFCT";
    private static final String TRACE_MASKF = "XLOGOFCF";
    private static final String TRACE_MASKD = "XLOGOFCD";
    private static final String TEXT_KEY = "ACTTSK01.TEXT";
    private static final String TITLE_KEY = "ACTTSK01.TITLE";
    private static final int YES = 1;
    private static final int NO = 2;
    private static final int OK = 1;
    private static final int CANCEL = 2;
    private int answer;
    private static final int UNDECIDED = 0;
    private static final int LOGOFF = 1;
    private static final int DISCONNECT = 2;
    private int operation;
    private boolean mainuiclosed;
    private boolean releaseEventThread;
    private int runningTasksCount;

    public LogoffApp(PresentationTaskParms parms) {
        super(parms);
    }

    protected Object runTask() throws Exception {
        Trace.trace(TRACE_MASKF, "-> LogoffApp.runTask()");
        if (CommonSystem.getCommonSystem().isUsingHTML()) {
            this.executeForHTML();
        } else {
            this.executeForAUIML();
        }
        Trace.trace(TRACE_MASKF, "<- LogoffApp.runTask()");
        return null;
    }

    private void executeForAUIML() throws Exception {
        PresentationTask[] activeTasks = TaskLauncher.getActiveTasks();
        if (activeTasks.length > 1) {
            Trace.trace(TRACE_MASKF, "   there is at least one active task, logoff is not allowed");
            TaskLauncher.dumpActiveTasks();
            BaseMessageText text = new BaseMessageText(TEXT_KEY);
            BaseMessageTitle title = new BaseMessageTitle(TITLE_KEY);
            CommonMsgApp.showMessageBox(null, title, text);
        } else {
            Trace.trace(TRACE_MASKF, "   there are no active tasks, logoff is allowed");
            Client client = new Client(TASKLET_NAME, "logoff");
            client.init();
            client.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeForHTML() throws Exception {
        block24: {
            block23: {
                block22: {
                    try {
                        PanelModel panel;
                        boolean showedPanel = false;
                        HMCSession hmcSession = this.getHMCSession();
                        String command = (String)this.getParms().getData("command");
                        if (command != null && command.equalsIgnoreCase("logoff")) {
                            this.operation = 1;
                        } else if (command != null && command.equalsIgnoreCase("disconnect")) {
                            this.operation = 2;
                        }
                        String mode = (String)this.getParms().getData("mode");
                        boolean bl = this.mainuiclosed = mode != null && mode.equalsIgnoreCase("mainwindowclosed");
                        if (this.mainuiclosed) {
                            PanelModelTaskPortal portal = this.getPanelModelTaskPortal();
                            String windowName = (String)this.getParms().getData("windowname");
                            if (windowName != null) {
                                portal.setWindowName(windowName);
                            }
                            portal.setRefreshEnabled(false);
                            TaskWindowPositionManager.getTaskWindowPositionManager(hmcSession).setWindowPosition(portal, (hmcSession.getAvailableScreenWidth() - 500) / 2, (hmcSession.getAvailableScreenHeight() - 500) / 2);
                            portal.setWindowOpen(true);
                            portal.setRedirectURL(ServletRuntime.getRuntime().getHMCContextPath() + "/connect?option=closeWindow");
                        }
                        if (this.operation == 0) {
                            this.operation = 1;
                            panel = new PanelModel("com.ibm.hwmca.base.logoff.res.choice", "com.ibm.hwmca.base.logoff.res.logoff", this, hmcSession.getUserContext().getLocales());
                            panel.addModelActionListener(this);
                            panel.render();
                            showedPanel = true;
                            while (true) {
                                int answer;
                                if ((answer = this.waitForAction()) == 2) {
                                    panel.dispose();
                                    Object var9_10 = null;
                                    this.releaseEventThread();
                                    if (!this.mainuiclosed) return;
                                    this.getPanelModelTaskPortal().setWindowOpen(false);
                                    return;
                                }
                                if (this.operation != 0) {
                                    panel.dispose();
                                    break;
                                }
                                this.releaseEventThread();
                            }
                        }
                        if (this.operation == 1 && (this.runningTasksCount = hmcSession.getRunningTasks().size() - 1) > 0) {
                            panel = new PanelModel("com.ibm.hwmca.base.logoff.res.killtasks", "com.ibm.hwmca.base.logoff.res.logoff", this, hmcSession.getUserContext().getLocales());
                            panel.addModelActionListener(this);
                            panel.render();
                            this.releaseEventThread();
                            showedPanel = true;
                            int answer = this.waitForAction();
                            panel.dispose();
                            if (answer == 2) {
                                break block22;
                            }
                        }
                        if (!showedPanel) {
                            panel = new PanelModel("com.ibm.hwmca.base.logoff.res.confirm", "com.ibm.hwmca.base.logoff.res.logoff", this, hmcSession.getUserContext().getLocales());
                            panel.addModelActionListener(this);
                            panel.render();
                            int answer = this.waitForAction();
                            panel.dispose();
                            if (answer == 2) {
                                break block23;
                            }
                        }
                        Trace.trace(TRACE_MASKT, (this.operation == 1 ? "Logging off" : "Disconnecting") + " user \"" + hmcSession.getUserContext().getUserName() + "\" from HMC session \"" + hmcSession.getSessionId() + "\".");
                        HttpSession httpSession = hmcSession.getHttpSession();
                        if (this.operation == 1) {
                            hmcSession.destroy();
                        } else {
                            hmcSession.disconnectFromWebSession(1);
                        }
                        httpSession.invalidate();
                        if (this.mainuiclosed) {
                            this.getPanelModelTaskPortal().setRedirectURL(null);
                        }
                        Client client = null;
                        try {
                            client = new Client(TASKLET_NAME, this.operation == 1 ? "logoff" : "disconnect");
                            client.init();
                            break block24;
                        }
                        finally {
                            if (client != null) {
                                client.terminate();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        this.releaseEventThread();
                        if (!this.mainuiclosed) throw throwable;
                        this.getPanelModelTaskPortal().setWindowOpen(false);
                        throw throwable;
                    }
                }
                Object var9_11 = null;
                this.releaseEventThread();
                if (!this.mainuiclosed) return;
                this.getPanelModelTaskPortal().setWindowOpen(false);
                return;
            }
            Object var9_12 = null;
            this.releaseEventThread();
            if (!this.mainuiclosed) return;
            this.getPanelModelTaskPortal().setWindowOpen(false);
            return;
        }
        Object var9_13 = null;
        this.releaseEventThread();
        if (!this.mainuiclosed) return;
        this.getPanelModelTaskPortal().setWindowOpen(false);
    }

    private synchronized int waitForAction() {
        while (this.answer == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        int result = this.answer;
        this.answer = 0;
        return result;
    }

    private synchronized void setAction(int answer) {
        this.answer = answer;
        this.notifyAll();
    }

    public void actionPerformed(ModelActionEvent event) {
        Trace.trace(TRACE_MASKT, "actionPerformed(" + event + ")");
        this.prepareToHandleEvent();
        String command = event.getActionCommand();
        if ("cancel".equals(command)) {
            this.setAction(2);
        } else {
            if (event.getSource() instanceof PanelModel) {
                ((PanelModel)event.getSource()).commitPanelChanges();
            }
            if (command.equals("yes")) {
                this.setAction(1);
            } else if (command.equals("no")) {
                this.setAction(2);
            } else if (command.equals("ok")) {
                this.setAction(1);
            }
        }
        this.waitForEventRelease();
    }

    private synchronized void prepareToHandleEvent() {
        this.releaseEventThread = false;
    }

    private synchronized void releaseEventThread() {
        this.releaseEventThread = true;
        this.notifyAll();
    }

    private synchronized void waitForEventRelease() {
        while (!this.releaseEventThread) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void logException(Throwable throwable) {
        new FrameworkLog(LogoffErrorIds.classLogInfo, 352, throwable).log();
    }

    protected void forceTermination(String reason) {
        this.setAction(2);
    }

    public void setLogoff(boolean loggingOff) {
        Trace.trace(TRACE_MASKT, "LogoffApp.setLogoff(" + loggingOff + ')');
        if (loggingOff) {
            this.operation = 1;
        } else if (this.operation == 1) {
            this.operation = 0;
        }
    }

    public boolean getLogoff() {
        return this.operation == 1;
    }

    public void setDisconnect(boolean disconnecting) {
        Trace.trace(TRACE_MASKT, "LogoffApp.setDisconnect(" + disconnecting + ')');
        if (disconnecting) {
            this.operation = 2;
        } else if (this.operation == 2) {
            this.operation = 0;
        }
    }

    public boolean getDisconnect() {
        return this.operation == 2;
    }

    public int getRunningTasksCount() {
        return this.runningTasksCount;
    }

    public boolean isMainUIWindowClosed() {
        return this.mainuiclosed;
    }

    public Collection getWindowNames() {
        Trace.trace(TRACE_MASKF, "LogoffApp().getWindowNames()");
        ArrayList<String> windowNames = new ArrayList<String>();
        PanelModelTaskPortal me = this.getPanelModelTaskPortal();
        Iterator iterator = this.getHMCSession().getKnownTasks().iterator();
        while (iterator.hasNext()) {
            PanelModelTaskPortal portal = (PanelModelTaskPortal)iterator.next();
            if (portal == me) continue;
            if (portal.isWindowOpen()) {
                windowNames.add(portal.getWindowName());
                portal.setWindowOpen(false);
            }
            Iterator jiterator = portal.getAdditionalWindowNames().iterator();
            while (jiterator.hasNext()) {
                String windowName = (String)jiterator.next();
                windowNames.add(windowName);
            }
            portal.closingAllAdditionalWindows();
        }
        Trace.trace(TRACE_MASKF, "Asking the first panel to close " + windowNames.size() + " task windows:");
        iterator = windowNames.iterator();
        while (iterator.hasNext()) {
            Trace.trace(TRACE_MASKF, " window \"" + iterator.next() + '\"');
        }
        return windowNames;
    }
}

